<?php
session_start();
require_once __DIR__ . '/db.php';

function getConfig() {
    global $pdo;
    $stmt = $pdo->query("SELECT * FROM config LIMIT 1");
    return $stmt->fetch();
}

function setConfig($codigo_index = null, $senha_admin_hash = null) {
    global $pdo;
    $cfg = getConfig();
    if (!$cfg) {
        $stmt = $pdo->prepare("INSERT INTO config (codigo_index, senha_admin) VALUES (:c, :s)");
        return $stmt->execute([':c'=>$codigo_index, ':s'=>$senha_admin_hash]);
    } else {
        $sql = "UPDATE config SET ";
        $sets = [];
        $params = [];
        if ($codigo_index !== null) { $sets[] = "codigo_index = :c"; $params[':c'] = $codigo_index; }
        if ($senha_admin_hash !== null) { $sets[] = "senha_admin = :s"; $params[':s'] = $senha_admin_hash; }
        if (count($sets) === 0) return false;
        $sql .= implode(", ", $sets);
        $stmt = $pdo->prepare($sql);
        return $stmt->execute($params);
    }
}

function isAdminLogged() {
    return isset($_SESSION['admin_logged']) && $_SESSION['admin_logged'] === true;
}

function requireAdmin() {
    if (!isAdminLogged()) {
        header("Location: login.php");
        exit;
    }
}

function fetchPaineis() {
    global $pdo;
    $stmt = $pdo->query("SELECT * FROM paineis ORDER BY id DESC");
    return $stmt->fetchAll();
}

function getPainel($id) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM paineis WHERE id = :id");
    $stmt->execute([':id'=>$id]);
    return $stmt->fetch();
}
?>