<?php
require_once __DIR__ . '/../includes/functions.php';
$cfg = getConfig();
$erro = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $senha = $_POST['senha'] ?? '';
    if (!$cfg) {
        $erro = 'Configuração não encontrada.';
    } else {
        if (password_verify($senha, $cfg['senha_admin'])) {
            $_SESSION['admin_logged'] = true;
            header("Location: painel.php");
            exit;
        } else {
            $erro = 'Senha incorreta.';
        }
    }
}
?>
<!doctype html>
<html lang="pt-BR">
<head><meta charset="utf-8"><title>Admin - Login</title></head>
<body style="font-family:Arial;padding:24px">
  <h2>Login Admin</h2>
  <?php if($erro): ?><p style="color:red"><?=htmlspecialchars($erro)?></p><?php endif; ?>
  <form method="post">
    <input type="password" name="senha" placeholder="Senha admin" required>
    <button type="submit">Entrar</button>
  </form>
</body>
</html>