<?php
require_once __DIR__ . '/../includes/functions.php';
requireAdmin();
$id = $_GET['id'] ?? null;
if (!$id) { header("Location: paineis.php"); exit; }
$p = getPainel($id);
if (!$p) { header("Location: paineis.php"); exit; }
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = $_POST['nome'] ?? '';
    $link = $_POST['link'] ?? '';
    $logo = $p['logo'];
    if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
        $tmp = $_FILES['logo']['tmp_name'];
        $fname = basename($_FILES['logo']['name']);
        $target = '../uploads/logos/' . time() . '_' . preg_replace('/[^A-Za-z0-9._-]/','_', $fname);
        if (move_uploaded_file($tmp, $target)) {
            $logo = $target;
        }
    } elseif (!empty($_POST['logo_url'])) {
        $logo = $_POST['logo_url'];
    }
    global $pdo;
    $stmt = $pdo->prepare("UPDATE paineis SET nome=:n, link=:l, logo=:g WHERE id=:id");
    $stmt->execute([':n'=>$nome, ':l'=>$link, ':g'=>$logo, ':id'=>$id]);
    $msg = 'Atualizado.';
    $p = getPainel($id);
}
?>
<!doctype html>
<html lang="pt-BR">
<head><meta charset="utf-8"><title>Editar Painel</title></head>
<body style="font-family:Arial;padding:20px">
  <h2>Editar Painel</h2>
  <?php if($msg): ?><p style="color:green"><?=$msg?></p><?php endif; ?>
  <form method="post" enctype="multipart/form-data">
    <label>Nome</label><br><input type="text" name="nome" value="<?=htmlspecialchars($p['nome'])?>" required><br>
    <label>Link</label><br><input type="url" name="link" value="<?=htmlspecialchars($p['link'])?>" required><br>
    <label>Logo atual</label><br><?php if($p['logo']): ?><img src="<?=htmlspecialchars($p['logo'])?>" style="max-width:140px"><br><?php endif; ?>
    <label>Substituir logo (arquivo)</label><br><input type="file" name="logo" accept="image/*"><br>
    <label>ou URL da logo</label><br><input type="text" name="logo_url" placeholder="https://..." value=""><br><br>
    <button type="submit">Salvar</button>
  </form>
  <p><a href="paineis.php">Voltar</a></p>
</body>
</html>