<?php
require_once __DIR__ . '/../includes/functions.php';
requireAdmin();
$cfg = getConfig();
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $novo_codigo = $_POST['codigo_index'] ?? null;
    $nova_senha = $_POST['senha_admin'] ?? null;
    $senha_hash = null;
    if ($nova_senha && strlen(trim($nova_senha))>0) {
        $senha_hash = password_hash($nova_senha, PASSWORD_DEFAULT);
    }
    setConfig($novo_codigo, $senha_hash);
    $msg = 'Configurações atualizadas.';
    $cfg = getConfig();
}
?>
<!doctype html>
<html lang="pt-BR">
<head><meta charset="utf-8"><title>Configurações</title></head>
<body style="font-family:Arial;padding:20px">
  <h2>Configurações</h2>
  <?php if($msg): ?><p style="color:green"><?=$msg?></p><?php endif; ?>
  <form method="post">
    <label>Código do index (código que os usuários usarão):</label><br>
    <input type="text" name="codigo_index" value="<?=htmlspecialchars($cfg['codigo_index'] ?? '')?>"><br><br>
    <label>Alterar senha admin (deixe vazio para manter):</label><br>
    <input type="password" name="senha_admin" placeholder="Nova senha"><br><br>
    <button type="submit">Salvar</button>
  </form>
  <p><a href="painel.php">Voltar</a></p>
</body>
</html>