<?php
require_once __DIR__ . '/../includes/functions.php';
requireAdmin();
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = $_POST['nome'] ?? '';
    $link = $_POST['link'] ?? '';
    $logo = '';
    // upload handling
    if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
        $tmp = $_FILES['logo']['tmp_name'];
        $fname = basename($_FILES['logo']['name']);
        $target = '../uploads/logos/' . time() . '_' . preg_replace('/[^A-Za-z0-9._-]/','_', $fname);
        if (move_uploaded_file($tmp, $target)) {
            $logo = $target;
        }
    } elseif (!empty($_POST['logo_url'])) {
        $logo = $_POST['logo_url'];
    }
    global $pdo;
    $stmt = $pdo->prepare("INSERT INTO paineis (nome, link, logo) VALUES (:n, :l, :g)");
    $stmt->execute([':n'=>$nome, ':l'=>$link, ':g'=>$logo]);
    $msg = 'Painel adicionado.';
}
?>
<!doctype html>
<html lang="pt-BR">
<head><meta charset="utf-8"><title>Adicionar Painel</title></head>
<body style="font-family:Arial;padding:20px">
  <h2>Adicionar Painel</h2>
  <?php if($msg): ?><p style="color:green"><?=$msg?></p><?php endif; ?>
  <form method="post" enctype="multipart/form-data">
    <label>Nome</label><br><input type="text" name="nome" required><br>
    <label>Link</label><br><input type="url" name="link" required><br>
    <label>Logo (arquivo)</label><br><input type="file" name="logo" accept="image/*"><br>
    <label>ou URL da logo</label><br><input type="text" name="logo_url" placeholder="https://..."><br><br>
    <button type="submit">Adicionar</button>
  </form>
  <p><a href="paineis.php">Voltar</a></p>
</body>
</html>