<?php
require_once 'includes/functions.php';
if (!isset($_SESSION['index_access']) || $_SESSION['index_access'] !== true) {
    header("Location: index.php");
    exit;
}
$paineis = fetchPaineis();
?>
<!doctype html>
<html lang="pt-BR">
<head>
<meta charset="utf-8">
<title>Painéis</title>
<style>
body{font-family:Arial,Helvetica,sans-serif;background:#f7f7f7;padding:24px}
.grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(220px,1fr));gap:16px}
.card{background:white;padding:12px;border-radius:8px;box-shadow:0 2px 8px rgba(0,0,0,.06);text-align:center}
.card img{max-width:120px;max-height:80px;object-fit:contain}
.card a{display:inline-block;margin-top:8px;padding:8px 10px;background:#007bff;color:white;border-radius:6px;text-decoration:none}
.header{display:flex;justify-content:space-between;align-items:center;margin-bottom:16px}
</style>
</head>
<body>
<div class="header">
  <h2>Painéis</h2>
  <div><a href="index.php">Voltar</a> | <a href="logout.php">Sair</a></div>
</div>
<div class="grid">
<?php foreach($paineis as $p): ?>
  <div class="card">
    <?php if($p['logo']): ?>
      <img src="<?=htmlspecialchars($p['logo'])?>" alt="<?=htmlspecialchars($p['nome'])?>">
    <?php endif; ?>
    <h3><?=htmlspecialchars($p['nome'])?></h3>
    <a href="<?=htmlspecialchars($p['link'])?>" target="_blank">Abrir painel</a>
  </div>
<?php endforeach; ?>
</div>
</body>
</html>